/***************************************************************************
                          serial.c  -  description
                             -------------------
    begin                : Tue Jun 13 2000
    copyright            : (C) 2000 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
 * Serial port Watchdog timer initialization & communication module
 *
 * 
 *
 * 
 *
 * This file initializes the serial port for watchdog commands & responses, then resets it back.
 * 
 * Two commands are used externally:
 *
 * test_serial: called with the /dev/ttyS* serial port device.  It returns 0 if the port
 *              can be used for reads & writes, negative if it can't.
 *
 * wd_cmd:      called with the /dev/ttyS* serial port device and the watchdog command, returns
 *              response in hex format, closing the serial port after each use.  
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <termio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include "def.h"
#include "serial.h"

int speed=B1200, bits=CS8, stopbits=CSTOPB, parity=0, i=0, fd = -1;
extern char *progname, error[];
char *device = NULL;		// serial device name
struct termio stbuf, svbuf;	// termios: svbuf=saved, stbuf=set 
UINT svmln, stmln;              //  Modem line settings: svmline=saved, stmline=set - used to toggle DTR

/* serial cleanup routine called as the routine exits */
void
cleanup_serial(int fd)
{
  if (fd > 0) {
    if (ioctl(fd, TCSETA, &svbuf) < 0) {  //reset port in case of modem
      sprintf(error, "%s: can't ioctl set device %s", progname, device);
      perror(error);
    }
    if (ioctl(fd, TIOCMSET, &svmln) < 0) { //reset DTR
      sprintf(error, "%s: can't ioctl set device %s", progname, device);
      perror(error);
    }
    close(fd);
  }
}


/* return file descriptor of successfully opened serial device or negative # */
int init_serial(char *dev)
{
  int fd=-1;			/* serial device file descriptor */

  if (dev != NULL)
    device = dev;
  else if ((device = getenv("SWD")) == NULL) /* default to env var */
    device = SWD;		/* or built-in default */
  if ((fd = open(device, O_RDWR | O_NOCTTY )) < 0) {
//##  if ((fd = open(device, O_RDWR | O_NOCTTY | O_NONBLOCK)) < 0) {
    sprintf(error, "%s: can't open device %s", progname, device);
    perror(error);
    return(-1);
  }

  /*  Get current port settings */
  if (ioctl(fd, TCGETA, &svbuf) < 0) {
    sprintf(error, "%s: can't ioctl get device %s", progname, device);
    perror(error);
    close(fd);
    return(-2);
  }

  /* Make a backup of the serial port settings */
  memcpy(&stbuf, &svbuf, sizeof(struct termio));

  /* Mangle serial port to our desire */
  stbuf.c_iflag = 0;
  stbuf.c_oflag = 0; 
  stbuf.c_lflag = 0;
  stbuf.c_cc[VMIN] = 4;
//##  stbuf.c_cc[VTIME] = 0;
  stbuf.c_cc[VTIME] = 0.1;
  stbuf.c_cflag = speed | bits | parity | stopbits | CLOCAL | CREAD;
  tcflush(fd, TCIFLUSH); /* Flush port */

  if (ioctl(fd, TCSETA, &stbuf) < 0) {
    sprintf(error, "%s: can't ioctl set device %s", progname, device);
    perror(error);
    cleanup_serial(fd);
    return(-1);
  }
  if (ioctl(fd, TIOCMGET, &svmln) < 0) { // get modem line settings
    sprintf(error, "%s: can't ioctl get device %s", progname, device);
    perror(error);
    close(fd);
    return(-1);
  }
  memcpy(&stmln, &svmln, sizeof(stmln));
  stmln &= ~TIOCM_DTR ;  //drop DTR
  if (ioctl(fd, TIOCMSET, &stmln) < 0) {
    sprintf(error, "%s: can't ioctl set device %s", progname, device);
    perror(error);
    cleanup_serial(fd);
    return(-1);
  }
  return(fd);
}

int test_serial(char *dev) {
    if (wd_cmd(dev, 34) == 6);
        return 0;
    return -1;
}
 
/* Submit command to watchdog & receive data */
int wd_cmd(char *dev, int wcmd){
  UBYTE b, strRxBuff[8], strTxBuff[8] = {0x01, 'W', 0x84, 0x00, 0x00};
  if (wcmd < 0x20) {
    return -1;
  }
  if ((fd = init_serial(dev)) < 0) {
      printf("Can't open serial port %s\n", dev);
      perror(error);
      return -1;
  }
  strTxBuff[3] = (UBYTE)wcmd; /* cmd to buffer */
  for(i=0, b=0; i < 4; i++)   /* compute checksum  */
    b += strTxBuff[i];
  strTxBuff[4] = (0 - b);
  printf("Write - ");

  if ((i = write(fd, &strTxBuff[0], 5)) <1) { /* send command to watchdog */
    printf ("Can't write to %s\n", dev);
    perror(error);
    cleanup_serial(fd);
    return(-4);
  }
  printf("Read \n");
//##  i = read(fd, &strRxBuff[0], 4);
  i = read(fd, &strRxBuff[0], 255);
  cleanup_serial(fd);
#ifdef DEBUG
  strRxBuff[i]=0;
  for (b = 0;b<i;b++)
  printf("Received: 0x%02x \n",strRxBuff[b]);
#endif
  b = (uint)strRxBuff[2];
  return (b);
}
